const fs = require("fs");
const path = require("path");
const { app, BrowserWindow, ipcMain } = require("electron");
const eventManager = require("./server/bl/event");

// Constants
const WINDOW_SCALE = 1;
const DEV = process.env.NODE_ENV == "development";

// Server API
fs.readdirSync(path.join(__dirname, "server/api")).forEach(filename => {
    const endpoint = filename.replace(".js", "");
    const methods = require(path.join(__dirname, "server/api", filename));
    Object.keys(methods).forEach(method => {
        const path = [endpoint, method].join("/");
        ipcMain.handle(path, async (_, ...args) => methods[method](...args));
    });
});

//
function createWindow() {
    const win = new BrowserWindow({
        // titleBarStyle: "hidden",
        width: 800 * WINDOW_SCALE,
        height: 600 * WINDOW_SCALE,
        webPreferences: {
            devTools: DEV,
            nativeWindowOpen: false,
            preload: path.join(__dirname, "preload.js")
        }
    });

    win.loadFile(path.join(__dirname, "index.html"));

    if (DEV) {
        win.webContents.openDevTools();
    }

    return win;
}

let ival = null;
app.on("will-quit", function () {
    clearInterval(ival);
});

app.on("ready", function () {
    const win = createWindow();

    eventManager.on("flash:state", (...args) => win.webContents.send("flash:state", ...args));

    ival = setInterval(function () {
        win.webContents.send("device:found", { type: "LINUS14" });
    }, 3000);
});
